/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.userrole;

import com.ibm.hwmca.base.userprof.RoleItem;
import com.ibm.hwmca.base.userprof.RoleTree;
import com.ibm.hwmca.base.userrole.UserRoleErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.tree.SimpleTreeNode;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.NodeDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.ArrayList;
import java.util.List;

public class NewObjectBean
extends PanelBean
implements UserRoleErrorIds {
    private String m_sNewName;
    private String m_sBasedOn;
    private ItemDescriptor[] m_cdBasedOn;
    private String m_sAllItemsTree;
    private NodeDescriptor[] m_ndAllItemsTree;
    private NodeDescriptor[] m_ndAllItemsTreeSelection;
    private String m_sNewItemsTree;
    private NodeDescriptor[] m_ndNewItemsTree;
    private NodeDescriptor[] m_ndNewItemsTreeSelection;
    List _systemObjects = new ArrayList();
    boolean modifyTask = false;
    boolean copyTask = false;
    boolean basedOnChanged = false;
    int selectedItem;
    UserTaskManager _utm;
    RoleTree curTree = null;
    RoleTree userTree = null;
    RoleTree modifiedTree;
    int _basedRole = 0;
    int _modifyRole;
    int path = 0;
    private static final String TRACE_MASKF = "USRNOBSF";
    private static final String TRACE_MASKT = "USRNOBST";
    private static final String TRACE_MASKD = "USRNOBSD";

    public NewObjectBean(List curRoles, int whichOne) {
        Trace.trace(TRACE_MASKT, "-> NewObjectBean.new(list) ");
        Trace.trace(TRACE_MASKT, "curRoles size " + curRoles.size());
        this._systemObjects = this.cleanupObjects(curRoles);
        Trace.trace(TRACE_MASKT, "objects size after cleanup " + this._systemObjects.size());
        this.curTree = (RoleTree)this._systemObjects.get(0);
        this.modifyTask = false;
        this.copyTask = false;
        this.path = whichOne;
    }

    public NewObjectBean(List curRoles, int basedRole, int whichOne) {
        Trace.trace(TRACE_MASKT, "-> NewObjectBean.copy(list, int) ");
        Trace.trace(TRACE_MASKT, "role size " + curRoles.size());
        Trace.trace(TRACE_MASKT, "basedon value " + basedRole);
        this._basedRole = basedRole;
        this.curTree = (RoleTree)curRoles.get(this._basedRole);
        this.modifiedTree = (RoleTree)this.curTree.clone();
        this.userTree = (RoleTree)this.curTree.clone();
        this.modifyTask = false;
        this.copyTask = true;
        this.path = whichOne;
        Trace.trace(TRACE_MASKT, "curRoles size " + curRoles.size());
        this._systemObjects = this.cleanupObjects(curRoles);
        Trace.trace(TRACE_MASKT, "objects size after cleanup " + this._systemObjects.size());
    }

    public NewObjectBean(List curRoles, int basedRole, int modifyRole, int whichOne) {
        Trace.trace(TRACE_MASKT, "-> NewObjectBean.modify(list, int, int) ");
        this._modifyRole = modifyRole;
        Trace.trace(TRACE_MASKT, "-> role size " + curRoles.size());
        Trace.trace(TRACE_MASKT, "-> basedon value " + basedRole);
        Trace.trace(TRACE_MASKT, "-> modifyRole value " + modifyRole);
        this._basedRole = basedRole;
        this.curTree = this._basedRole > -1 ? (RoleTree)curRoles.get(this._basedRole) : (RoleTree)curRoles.get(modifyRole);
        this.modifiedTree = (RoleTree)curRoles.get(modifyRole);
        this.userTree = (RoleTree)this.modifiedTree.clone();
        this.modifyTask = true;
        this.copyTask = false;
        this.path = whichOne;
        Trace.trace(TRACE_MASKT, "curRoles size " + curRoles.size());
        this._systemObjects = this.cleanupObjects(curRoles);
        Trace.trace(TRACE_MASKT, "objects size after cleanup " + this._systemObjects.size());
        Trace.trace(TRACE_MASKT, "-> modifiedTree name " + this.modifiedTree.getName());
        Trace.trace(TRACE_MASKT, "-> curTree name " + this.curTree.getName());
        Trace.trace(TRACE_MASKT, "-> path " + this.path);
    }

    public void setNewName(String s) throws IllegalUserDataException {
        this.m_sNewName = s;
    }

    public String getNewName() {
        return this.m_sNewName;
    }

    public ItemDescriptor[] getBasedOnList() {
        return this.m_cdBasedOn;
    }

    public void setBasedOn(String s) throws IllegalUserDataException {
        int index;
        Trace.trace(TRACE_MASKT, "-> setBasedOn " + s);
        this.selectedItem = index = this.findSelection(s);
        this.basedOnChanged = true;
        this.m_sAllItemsTree = null;
        this.m_sNewItemsTree = null;
        this.fillAllTree(index);
        if (!this.copyTask) {
            this.userTree.removeAll();
        }
        if (this._utm != null) {
            this._utm.refreshElement("NewItemsTree");
        }
        this.m_sBasedOn = s;
        Trace.trace(TRACE_MASKT, "<- setBasedOn ");
    }

    public String getBasedOn() {
        return this.m_sBasedOn;
    }

    public void setAllItemsTreeSelection(NodeDescriptor[] selected) {
        if (selected == null) {
            Trace.trace(TRACE_MASKF, "PER selected == null");
            this.m_ndAllItemsTreeSelection = new NodeDescriptor[0];
        } else if (selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                Trace.trace(TRACE_MASKF, "PER selected[" + i + "]=" + selected[i]);
                ++i;
            }
            this.m_ndAllItemsTreeSelection = selected;
        } else {
            Trace.trace(TRACE_MASKF, "PER selected.length == 0");
            this.m_ndAllItemsTreeSelection = new NodeDescriptor[0];
        }
    }

    public NodeDescriptor[] getAllItemsTreeSelection() {
        if (this.m_ndAllItemsTreeSelection == null) {
            Trace.trace(TRACE_MASKT, "getAllItemsTreeSelection null");
            return new NodeDescriptor[0];
        }
        return this.m_ndAllItemsTreeSelection;
    }

    public void setAllItemsTreeTreeParent(String name) {
        this.m_sAllItemsTree = name;
    }

    public NodeDescriptor[] getAllItemsTreeChildren() {
        RoleItem roleItem = null;
        SimpleTreeNode locatedItem = null;
        Trace.trace(TRACE_MASKT, "-> getAllItemsTreechildren()");
        if (this.m_sAllItemsTree == null) {
            NodeDescriptor leafDesc = new NodeDescriptor();
            leafDesc.setLeaf(true);
            if (this.curTree != null) {
                this.m_ndAllItemsTree = new NodeDescriptor[this.curTree.getChildCount()];
                Trace.trace(TRACE_MASKT, "m_ndAllItemsTree size " + this.curTree.getChildCount());
                int i = 0;
                while (i < this.curTree.getChildCount()) {
                    roleItem = (RoleItem)this.curTree.getChildAt(i);
                    String itemName = roleItem.getName().toString();
                    Trace.trace(TRACE_MASKT, "adding item to alltree " + itemName);
                    this.m_ndAllItemsTree[i] = new NodeDescriptor("l" + i + "-" + (String)roleItem.getKey(), itemName);
                    Trace.trace(TRACE_MASKT, "done building alltree child count is " + roleItem.getChildCount());
                    if (roleItem.getChildCount() > 0) {
                        this.m_ndAllItemsTree[i].setLeaf(false);
                        this.m_ndAllItemsTree[i].setExpandRequested(false);
                    } else {
                        this.m_ndAllItemsTree[i].setImageSrc(leafDesc.getImageSrc());
                        this.m_ndAllItemsTree[i].setExpandRequested(false);
                    }
                    ++i;
                }
            } else {
                Trace.trace(TRACE_MASKT, "getAllItemsTreeChildren curTree is null");
            }
        } else {
            int l = 0;
            while (l < this.curTree.getChildCount() && locatedItem == null) {
                roleItem = (RoleItem)this.curTree.getChildAt(l);
                String itemKey = this.m_sAllItemsTree;
                if (itemKey.indexOf("-") >= 0) {
                    itemKey = itemKey.substring(itemKey.indexOf("-") + 1);
                }
                locatedItem = this.findChild(roleItem, itemKey);
                ++l;
            }
            if (locatedItem != null) {
                this.m_ndAllItemsTree = new NodeDescriptor[locatedItem.getChildCount()];
                int i = 0;
                while (i < locatedItem.getChildCount()) {
                    RoleItem childItem = (RoleItem)locatedItem.getChildAt(i);
                    String itemName = childItem.getName().toString();
                    Trace.trace(TRACE_MASKT, "adding childitem to allTree " + itemName);
                    this.m_ndAllItemsTree[i] = new NodeDescriptor("lc-" + (String)childItem.getKey(), itemName);
                    if (childItem.getChildCount() > 0) {
                        this.m_ndAllItemsTree[i].setLeaf(false);
                        this.m_ndAllItemsTree[i].setExpandRequested(false);
                    } else {
                        this.m_ndAllItemsTree[i].setLeaf(true);
                        this.m_ndAllItemsTree[i].setExpandRequested(false);
                    }
                    ++i;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- getAllItemsTreechildren()");
        return this.m_ndAllItemsTree;
    }

    public void setNewItemsTreeSelection(NodeDescriptor[] selected) {
        if (selected == null) {
            this.m_ndNewItemsTreeSelection = new NodeDescriptor[0];
            Trace.trace(TRACE_MASKT, "m_ndNewItemsTreeSelection is null");
        } else {
            this.m_ndNewItemsTreeSelection = selected.length > 0 ? selected : new NodeDescriptor[0];
        }
    }

    public NodeDescriptor[] getNewItemsTreeSelection() {
        if (this.m_ndNewItemsTreeSelection == null) {
            return new NodeDescriptor[0];
        }
        return this.m_ndNewItemsTreeSelection;
    }

    public void setNewItemsTreeTreeParent(String name) {
        this.m_sNewItemsTree = name;
    }

    public NodeDescriptor[] getNewItemsTreeChildren() {
        RoleItem roleItem = null;
        SimpleTreeNode locatedItem = null;
        Trace.trace(TRACE_MASKT, "-> getNewItemsTreechildren()");
        if (this.m_sNewItemsTree == null) {
            if (this.userTree != null) {
                this.m_ndNewItemsTree = new NodeDescriptor[this.userTree.getChildCount()];
                int i = 0;
                while (i < this.userTree.getChildCount()) {
                    roleItem = (RoleItem)this.userTree.getChildAt(i);
                    String itemName = roleItem.getName().toString();
                    Trace.trace(TRACE_MASKT, "adding parent item to newTree " + itemName);
                    Trace.trace(TRACE_MASKT, "class of roleItem.getKey() is: " + roleItem.getKey());
                    this.m_ndNewItemsTree[i] = new NodeDescriptor("r" + String.valueOf(i) + "-" + (String)roleItem.getKey(), itemName);
                    if (roleItem.getChildCount() > 0) {
                        this.m_ndNewItemsTree[i].setLeaf(false);
                        this.m_ndNewItemsTree[i].setExpandRequested(false);
                    }
                    ++i;
                }
            } else {
                Trace.trace(TRACE_MASKT, "right tree is null in getNewItemsTreeChildren ");
            }
            Trace.trace(TRACE_MASKT, "<- getNewItemsTreechildren()");
        } else {
            int l = 0;
            while (l < this.userTree.getChildCount() && locatedItem == null) {
                roleItem = (RoleItem)this.userTree.getChildAt(l);
                String itemKey = this.m_sNewItemsTree;
                if (itemKey.indexOf("-") >= 0) {
                    itemKey = itemKey.substring(itemKey.indexOf("-") + 1);
                }
                locatedItem = this.findChild(roleItem, itemKey);
                ++l;
            }
            if (locatedItem != null) {
                this.m_ndNewItemsTree = new NodeDescriptor[locatedItem.getChildCount()];
                int i = 0;
                while (i < locatedItem.getChildCount()) {
                    RoleItem childItem = (RoleItem)locatedItem.getChildAt(i);
                    String itemName = childItem.getName().toString();
                    Trace.trace(TRACE_MASKT, "adding childitem to newTree " + itemName);
                    this.m_ndNewItemsTree[i] = new NodeDescriptor("rc" + String.valueOf(i) + "-" + (String)childItem.getKey(), itemName);
                    if (childItem.getChildCount() > 0) {
                        this.m_ndNewItemsTree[i].setLeaf(false);
                        this.m_ndNewItemsTree[i].setExpandRequested(false);
                    } else {
                        this.m_ndNewItemsTree[i].setLeaf(true);
                        this.m_ndNewItemsTree[i].setExpandRequested(false);
                    }
                    ++i;
                }
            }
            Trace.trace(TRACE_MASKT, "<- getNewItemsTreechildren()");
        }
        return this.m_ndNewItemsTree;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void setUTM(UserTaskManager utm) {
        this._utm = utm;
    }

    public UserTaskManager getUTM() {
        return this._utm;
    }

    public void prepare() {
        this.setUTM(this.userTaskManager);
        if (this.path == 0) {
            if (this.modifyTask) {
                this.userTaskManager.setEnabled("NewName", false);
                this.userTaskManager.setCaptionText("NewObjectPanel", new BaseMessageTitle("ADM9021").toString());
            } else if (this.copyTask) {
                this.userTaskManager.setEnabled("NewName", true);
                this.userTaskManager.setEnabled("BasedOn", true);
                this.userTaskManager.setCaptionText("NewObjectPanel", new BaseMessageTitle("ADM9022").toString());
            } else {
                this.userTaskManager.setCaptionText("NewObjectPanel", new BaseMessageTitle("ADM9023").toString());
            }
        } else if (this.modifyTask) {
            this.userTaskManager.setEnabled("NewName", false);
            this.userTaskManager.setCaptionText("NewTaskPanel", new BaseMessageTitle("ADM9021").toString());
        } else if (this.copyTask) {
            this.userTaskManager.setEnabled("NewName", true);
            this.userTaskManager.setEnabled("BasedOn", true);
            this.userTaskManager.setCaptionText("NewTaskPanel", new BaseMessageTitle("ADM9022").toString());
        } else {
            this.userTaskManager.setCaptionText("NewTaskPanel", new BaseMessageTitle("ADM9023").toString());
        }
    }

    public void load() {
        this.m_sNewName = "";
        this.m_sBasedOn = "";
        this.m_cdBasedOn = new ItemDescriptor[0];
        this.m_sAllItemsTree = "";
        this.m_ndAllItemsTree = new NodeDescriptor[0];
        this.m_ndAllItemsTreeSelection = new NodeDescriptor[0];
        this.m_sNewItemsTree = "";
        this.m_ndNewItemsTree = new NodeDescriptor[0];
        this.m_ndNewItemsTreeSelection = new NodeDescriptor[0];
        int roleSize = this._systemObjects.size();
        this.m_sBasedOn = "";
        this.m_cdBasedOn = new ItemDescriptor[roleSize];
        Trace.trace(TRACE_MASKT, "number of potential basedon items " + this._systemObjects.size());
        int i = 0;
        while (i < roleSize) {
            RoleTree itemTree = (RoleTree)this._systemObjects.get(i);
            Trace.trace(TRACE_MASKT, "Load - fillbasedon " + itemTree.getName().toString());
            Trace.trace(TRACE_MASKT, "canbebasedon value is " + itemTree.getCanBeBasedOn());
            String itemName = itemTree.getName().toString();
            this.m_cdBasedOn[i] = new ItemDescriptor(String.valueOf(i), itemName);
            ++i;
        }
        Trace.trace(TRACE_MASKT, "string for setbasedon is " + this.curTree.getName().toString());
        this.setBasedOn(this.curTree.getName().toString());
        if (this.modifyTask) {
            Trace.trace(TRACE_MASKT, "Load-modifytask is " + this.modifiedTree.getName().toString());
            this.setNewName(this.modifiedTree.getName().toString());
            this.userTree = (RoleTree)this.modifiedTree.clone();
            this.userTree.setName(this.curTree.getName());
            this.userTree.setKey(this.curTree.getKey());
            this.basedOnChanged = false;
            if (this._utm != null) {
                this._utm.refreshElement("NewItemsTree");
            }
        }
        if (this.copyTask) {
            this.userTree = (RoleTree)this.modifiedTree.clone();
            if (this._utm != null) {
                this._utm.refreshElement("NewItemsTree");
            }
        }
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent event) {
        String actionCommand = event.getActionCommand();
        String command = event.getElementName();
        PanelTaskletRequest request = new PanelTaskletRequest();
        if (command.equals("addButton")) {
            this.addButton();
        } else if (command.equals("removeButton")) {
            this.removeButton();
        } else if (command.equals("okButton")) {
            UserTaskManager utm = (UserTaskManager)event.getSource();
            try {
                utm.storeAllElements();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.getNewName() == null || this.getNewName().length() < 1) {
                this.issueRoleNameError();
                return;
            }
            request.setData("permissionTree", this.userTree);
            if (this.getBasedOn() == null || this.getBasedOn().length() < 1) {
                this.issueBasedOnError();
                return;
            }
            if (this.modifyTask) {
                request.setData("index", new Integer(this._modifyRole));
                if (this.path == 0) {
                    request.setData("action", "objectDoModify");
                } else {
                    request.setData("action", "taskDoModify");
                }
                this.postTaskletRequest(request);
            } else {
                boolean result = this.verifyName(this.getNewName());
                if (!result) {
                    return;
                }
                if (this.path == 0) {
                    request.setData("action", "objectDoAdd");
                } else {
                    request.setData("action", "taskDoAdd");
                }
                String newName = this.getNewName();
                request.setData("newName", newName);
                this.postTaskletRequest(request);
            }
        } else if (actionCommand.equalsIgnoreCase("CANCEL")) {
            request.setCanceled();
            this.postTaskletRequest(request);
        } else {
            this.dispose();
        }
    }

    public int findSelection(String s) {
        int index = 0;
        Trace.trace(TRACE_MASKT, "-> findSelection(s) " + s);
        Trace.trace(TRACE_MASKT, "-> findSelection ObjectSize is " + this._systemObjects.size());
        int i = 0;
        while (i < this._systemObjects.size()) {
            RoleItem roleItem = (RoleItem)this._systemObjects.get(i);
            String itemName = roleItem.getName().toString();
            Trace.trace(TRACE_MASKT, "-> comparing itemName " + itemName);
            Trace.trace(TRACE_MASKT, "-> to basedonstring " + s);
            if (itemName.equals(s)) {
                index = i;
                i = this._systemObjects.size();
                Trace.trace(TRACE_MASKT, "object found in findSelection " + index);
            }
            ++i;
        }
        Trace.trace(TRACE_MASKT, "index returned from findselection is " + index);
        return index;
    }

    public void fillAllTree(int index) {
        boolean r = false;
        Trace.trace(TRACE_MASKT, "-> fillalltree() " + index);
        RoleTree roleTree = (RoleTree)this._systemObjects.get(index);
        Trace.trace(TRACE_MASKT, "-> roleTreeName in fillAllTree() " + roleTree.getName());
        this.dumpTree(roleTree);
        this.curTree = roleTree;
        if (!this.modifyTask) {
            this.userTree = (RoleTree)roleTree.clone();
        } else if (this.basedOnChanged) {
            this.userTree = (RoleTree)roleTree.clone();
            this.userTree.removeAll();
            this.basedOnChanged = false;
        }
        List children = roleTree.getChildren();
        int size = children.size();
        Trace.trace(TRACE_MASKT, "-> fillAllTree() child size  " + children.size());
        this.m_ndAllItemsTree = new NodeDescriptor[size];
        int i = 0;
        while (i < size) {
            RoleItem roleItem = (RoleItem)children.get(i);
            String itemName = roleItem.getName().toString();
            this.m_ndAllItemsTree[i] = new NodeDescriptor("ac-" + (String)roleItem.getKey(), itemName);
            Trace.trace(TRACE_MASKT, "-> fillAllTree() adding child " + itemName);
            if (roleItem.getChildCount() > 0) {
                this.m_ndAllItemsTree[i].setLeaf(false);
                this.m_ndAllItemsTree[i].setExpandRequested(false);
            } else {
                this.m_ndAllItemsTree[i].setLeaf(true);
                this.m_ndAllItemsTree[i].setExpandRequested(false);
            }
            ++i;
        }
        this.setAllItemsTreeSelection(this.m_ndAllItemsTree);
        if (this._utm != null) {
            this._utm.refreshElement("AllItemsTree");
            this._utm.refreshElement("NewItemsTree");
        }
        Trace.trace(TRACE_MASKT, "<- fillalltree() " + index);
    }

    public void addButton() {
        boolean parentFound = false;
        Trace.trace(TRACE_MASKT, "-> addButton()");
        RoleItem curSelection = this.findAllTreeSelection();
        if (curSelection != null) {
            Trace.trace(TRACE_MASKT, "curSelection value is " + curSelection);
        } else {
            Trace.trace(TRACE_MASKT, "curSelection is null ");
        }
        if (curSelection != null) {
            Trace.trace(TRACE_MASKT, "curSelection value is " + curSelection.getName());
            if (curSelection.getLevel() > 1) {
                Trace.trace(TRACE_MASKT, "currentSelection is greater than level 1");
                RoleItem parentItem = this.getLevelOneParent(curSelection);
                Trace.trace(TRACE_MASKT, "leveloneparent " + parentItem.getName().toString());
                RoleItem parentFolder = this.findParentFolder(parentItem, this.userTree);
                if (parentFolder != null) {
                    this.addChildToParent(curSelection, parentFolder);
                } else {
                    RoleItem newParent = (RoleItem)parentItem.clone();
                    newParent.removeAll();
                    newParent = this.addChildToParent(curSelection, newParent);
                    this.userTree.add(newParent);
                }
            } else {
                Trace.trace(TRACE_MASKT, "currentSelection is level 1");
                RoleItem parentFolder = this.findParentFolder(curSelection, this.userTree);
                if (parentFolder == null) {
                    this.userTree.add((RoleItem)curSelection.clone());
                } else {
                    Trace.trace(TRACE_MASKT, "parent already in the tree");
                    RoleItem parentItem = this.getLevelOneParent(curSelection);
                    Trace.trace(TRACE_MASKT, "leveloneparent " + parentItem.getName().toString());
                    this.userTree.remove(parentFolder);
                    RoleItem newParent = (RoleItem)parentItem.clone();
                    this.userTree.add(newParent);
                }
            }
            if (this._utm != null) {
                this._utm.refreshElement("NewItemsTree");
            }
        } else {
            this.issueAddError();
        }
        Trace.trace(TRACE_MASKT, "<- addButton()");
    }

    public RoleItem findAllTreeSelection() {
        RoleItem roleItem = null;
        RoleItem locatedItem = null;
        Trace.trace(TRACE_MASKT, "-> findAllTreeSelection ");
        if (this.curTree != null) {
            Trace.trace(TRACE_MASKT, "curTree value is " + this.curTree);
            Trace.trace(TRACE_MASKT, "curTree kid count is " + this.curTree.getChildCount());
            int l = 0;
            while (l < this.curTree.getChildCount() && locatedItem == null) {
                String itemKey;
                roleItem = (RoleItem)this.curTree.getChildAt(l);
                Trace.trace(TRACE_MASKT, "roleItem is " + roleItem.getKey().toString());
                if (this.m_ndAllItemsTreeSelection != null && this.m_ndAllItemsTreeSelection.length > 0) {
                    itemKey = this.m_ndAllItemsTreeSelection[0].getName();
                    if (itemKey.indexOf("-") >= 0) {
                        itemKey = itemKey.substring(itemKey.indexOf("-") + 1);
                    }
                    Trace.trace(TRACE_MASKT, "itemkey is " + itemKey);
                    locatedItem = this.findChild(roleItem, itemKey);
                } else {
                    itemKey = this.m_sAllItemsTree;
                    if (itemKey.indexOf("-") >= 0) {
                        itemKey = itemKey.substring(itemKey.indexOf("-") + 1);
                    }
                    Trace.trace(TRACE_MASKT, "before findChild itemkey is " + itemKey);
                    locatedItem = this.findChild(roleItem, itemKey);
                }
                ++l;
            }
        }
        Trace.trace(TRACE_MASKT, "<- findAllTreeSelection ");
        return locatedItem;
    }

    public void removeButton() {
        Trace.trace(TRACE_MASKT, "-> removeButton ");
        Object obj = null;
        boolean itemFound = false;
        RoleItem foundItem = this.findNewTreeSelection();
        if (foundItem != null) {
            Trace.trace(TRACE_MASKT, "foundItem is " + foundItem.getName().toString());
            if (foundItem.isLeaf()) {
                RoleItem parentItem = (RoleItem)foundItem.getParent();
                if (parentItem == null) {
                    this.userTree.remove(foundItem);
                    Trace.trace(TRACE_MASKT, "parentItem is null");
                } else {
                    parentItem.remove(foundItem);
                    Trace.trace(TRACE_MASKT, "parentItem is " + parentItem.getName().toString());
                }
            } else {
                RoleItem parentItem = (RoleItem)foundItem.getParent();
                if (parentItem == null) {
                    this.userTree.remove(foundItem);
                    Trace.trace(TRACE_MASKT, "parentItem is null");
                } else {
                    parentItem.remove(foundItem);
                    Trace.trace(TRACE_MASKT, "parentItem is " + parentItem.getName().toString());
                }
            }
            this.m_ndNewItemsTreeSelection = new NodeDescriptor[0];
            this.userTaskManager.setSelectedElementNames("NewItemsTree", new String[0]);
            if (this._utm != null) {
                this._utm.refreshElement("NewItemsTree");
            }
        } else {
            this.issueRemoveError();
        }
        Trace.trace(TRACE_MASKT, "<- removeButton ");
    }

    public RoleItem findNewTreeSelection() {
        RoleItem roleItem = null;
        RoleItem locatedItem = null;
        Trace.trace(TRACE_MASKT, "-> findNewTreeSelection ");
        int l = 0;
        while (l < this.userTree.getChildCount() && locatedItem == null) {
            String itemKey;
            roleItem = (RoleItem)this.userTree.getChildAt(l);
            if (this.m_ndNewItemsTreeSelection != null && this.m_ndNewItemsTreeSelection.length > 0) {
                itemKey = this.m_ndNewItemsTreeSelection[0].getName();
                Trace.trace(TRACE_MASKF, "PER itemKey is " + itemKey);
                itemKey = this.adjustKey(itemKey);
                locatedItem = this.findChild(roleItem, itemKey);
            } else {
                itemKey = this.m_sNewItemsTree;
                itemKey = this.adjustKey(itemKey);
                locatedItem = this.findChild(roleItem, itemKey);
            }
            ++l;
        }
        Trace.trace(TRACE_MASKT, "<- findNewTreeSelection ");
        return locatedItem;
    }

    public RoleItem findChild(RoleItem roleItem, String mySelection) {
        boolean childLocated = false;
        RoleItem childItem = null;
        RoleItem subItem = null;
        Trace.trace(TRACE_MASKT, "-> findChild ");
        Trace.trace(TRACE_MASKT, "item comparing with " + roleItem.getKey().toString());
        Trace.trace(TRACE_MASKT, "selection looking for " + mySelection);
        if (roleItem.getKey().toString().equals(mySelection)) {
            childLocated = true;
            Trace.trace(TRACE_MASKT, "<- toplevel findChild " + childLocated);
            return roleItem;
        }
        int l = 0;
        while (l < roleItem.getChildCount() && !childLocated) {
            childItem = (RoleItem)roleItem.getChildAt(l);
            Trace.trace(TRACE_MASKT, "childItem value " + childItem.getName());
            Trace.trace(TRACE_MASKT, "curItem looking for is " + mySelection);
            if (childItem.getKey().toString().equals(mySelection)) {
                Trace.trace(TRACE_MASKT, "childItem found ");
                childLocated = true;
            } else {
                Trace.trace(TRACE_MASKT, "getChild childItem kid count " + childItem.getChildCount());
                int s = 0;
                while (s < childItem.getChildCount() && !childLocated) {
                    subItem = (RoleItem)childItem.getChildAt(s);
                    Trace.trace(TRACE_MASKT, "childItem value " + childItem.getName());
                    Trace.trace(TRACE_MASKT, "curItem looking for is " + mySelection);
                    RoleItem foundItem = this.findChild(subItem, mySelection);
                    if (foundItem != null) {
                        childLocated = true;
                        childItem = foundItem;
                        Trace.trace(TRACE_MASKT, "findchild found item #2");
                    }
                    ++s;
                }
            }
            ++l;
        }
        Trace.trace(TRACE_MASKT, "<- findChild " + childLocated);
        if (childLocated) {
            return childItem;
        }
        return null;
    }

    public void issueAddError() {
        if (this.path == 0) {
            try {
                BaseMessageTitle title = new BaseMessageTitle("ADM9006");
                BaseMessageText msg = new BaseMessageText("ADM0008");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (HException e) {}
        } else {
            try {
                BaseMessageTitle title = new BaseMessageTitle("ADM9010");
                BaseMessageText msg = new BaseMessageText("ADM0018");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (HException e) {}
        }
    }

    public void issueRemoveError() {
        if (this.path == 0) {
            try {
                BaseMessageTitle title = new BaseMessageTitle("ADM9011");
                BaseMessageText msg = new BaseMessageText("ADM0013");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (HException e) {}
        } else {
            try {
                BaseMessageTitle title = new BaseMessageTitle("ADM9012");
                BaseMessageText msg = new BaseMessageText("ADM0014");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (HException e) {}
        }
    }

    public void issuePermissionError() {
        try {
            BaseMessageTitle title = new BaseMessageTitle("ADM9015");
            BaseMessageText msg = new BaseMessageText("ADM0017");
            CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
        }
        catch (HException e) {}
    }

    public void issueRoleNameError() {
        try {
            BaseMessageTitle title = new BaseMessageTitle("ADM9013");
            BaseMessageText msg = new BaseMessageText("ADM0015");
            CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
        }
        catch (HException e) {}
    }

    public void issueBasedOnError() {
        try {
            BaseMessageTitle title = new BaseMessageTitle("ADM9014");
            BaseMessageText msg = new BaseMessageText("ADM0016");
            CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
        }
        catch (HException e) {}
    }

    public String adjustKey(String itemKey) {
        if (itemKey.indexOf("-") >= 0) {
            itemKey = itemKey.substring(itemKey.indexOf("-") + 1);
        }
        return itemKey;
    }

    public void dumpTree(RoleTree roleTree) {
        Trace.trace(TRACE_MASKT, "--> dumpTree = " + roleTree.getName());
        Trace.trace(TRACE_MASKT, "child count of basedonrole " + roleTree.getChildCount());
        List children = roleTree.getChildren();
        int size = children.size();
        Trace.trace(TRACE_MASKT, "-> dumpTree children count " + children.size());
        int i = 0;
        while (i < size) {
            RoleItem roleItem = (RoleItem)children.get(i);
            String itemName = roleItem.getName().toString();
            Trace.trace(TRACE_MASKT, "folder item name in tree is " + itemName);
            if (roleItem.getChildCount() > 0) {
                int l = 0;
                while (l < roleItem.getChildCount()) {
                    RoleItem nextItem = (RoleItem)roleItem.getChildAt(l);
                    String childName = nextItem.getName().toString();
                    Trace.trace(TRACE_MASKT, "leaf child name in tree is " + childName);
                    if (nextItem.getChildCount() > 0) {
                        int s = 0;
                        while (s < nextItem.getChildCount()) {
                            RoleItem aItem = (RoleItem)nextItem.getChildAt(s);
                            String subName = aItem.getName().toString();
                            Trace.trace(TRACE_MASKT, "sub leaf child name in tree is " + subName);
                            ++s;
                        }
                    }
                    ++l;
                }
            }
            ++i;
        }
    }

    public void dumpItem(RoleItem curItem) {
        Trace.trace(TRACE_MASKT, "--> dumpItem = " + curItem.getName());
        Trace.trace(TRACE_MASKT, "child count of roleitem " + curItem.getChildCount());
        List children = curItem.getChildren();
        int size = children.size();
        int i = 0;
        while (i < size) {
            RoleItem roleItem = (RoleItem)children.get(i);
            String itemName = roleItem.getName().toString();
            Trace.trace(TRACE_MASKT, "folder item name in tree is " + itemName);
            if (roleItem.getChildCount() > 0) {
                int l = 0;
                while (l < roleItem.getChildCount()) {
                    RoleItem nextItem = (RoleItem)roleItem.getChildAt(l);
                    String childName = nextItem.getName().toString();
                    Trace.trace(TRACE_MASKT, "leaf child name in tree is " + childName);
                    if (nextItem.getChildCount() > 0) {
                        this.dumpItem(nextItem);
                    }
                    ++l;
                }
            }
            ++i;
        }
    }

    public boolean verifyName(String name) {
        boolean validName = true;
        int roleSize = this._systemObjects.size();
        int i = 0;
        while (i < roleSize) {
            RoleTree itemTree = (RoleTree)this._systemObjects.get(i);
            String itemName = itemTree.getName().toString();
            if (name.equals(itemName)) {
                try {
                    BaseMessageTitle title = new BaseMessageTitle("ADM9013");
                    BaseMessageText msg = new BaseMessageText("ADM0026");
                    CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
                }
                catch (HException e) {
                    // empty catch block
                }
                validName = false;
            }
            ++i;
        }
        return validName;
    }

    public List cleanupObjects(List theObjects) {
        ArrayList<RoleTree> curObjects = new ArrayList<RoleTree>();
        int roleSize = theObjects.size();
        int i = 0;
        while (i < roleSize) {
            RoleTree itemTree = (RoleTree)theObjects.get(i);
            Trace.trace(TRACE_MASKT, "cleanupObjects - " + itemTree.getName().toString());
            Trace.trace(TRACE_MASKT, "canbebasedon value is " + itemTree.getCanBeBasedOn());
            if (itemTree.getCanBeBasedOn()) {
                curObjects.add(itemTree);
            }
            ++i;
        }
        return curObjects;
    }

    public RoleItem getLevelOneParent(RoleItem selection) {
        while (selection.getLevel() > 1) {
            selection = (RoleItem)selection.getParent();
        }
        return selection;
    }

    public RoleItem addChildToParent(RoleItem curSelection, RoleItem parentTree) {
        boolean itemFound = false;
        Trace.trace(TRACE_MASKT, "-> addChildToParent ");
        Trace.trace(TRACE_MASKT, "parentTree to build " + parentTree.getName());
        Trace.trace(TRACE_MASKT, "selection to add " + curSelection.getName());
        Trace.trace(TRACE_MASKT, "parentTree size to start " + parentTree.getChildCount());
        RoleItem selectedParent = (RoleItem)curSelection.getParent();
        Trace.trace(TRACE_MASKT, "addChildToParent selected objects parent is " + selectedParent.getName());
        RoleItem mdlItem = this.findSubFolder(selectedParent, parentTree);
        if (mdlItem != null) {
            Trace.trace(TRACE_MASKT, "mdlItem value " + mdlItem.getName().toString());
            RoleItem childItem = this.findSubFolder(curSelection, mdlItem);
            if (childItem == null) {
                mdlItem.add((RoleItem)curSelection.clone());
            } else {
                Trace.trace(TRACE_MASKT, "child is already in the tree - don't add ");
                mdlItem.remove(childItem);
                mdlItem.add((RoleItem)curSelection.clone());
            }
        } else {
            Trace.trace(TRACE_MASKT, "parent not found in the tree so create one ");
            RoleItem clonedParent = (RoleItem)selectedParent.clone();
            clonedParent.removeAll();
            Trace.trace(TRACE_MASKT, "selected  objects parent has how many kids " + clonedParent.getChildCount());
            Trace.trace(TRACE_MASKT, "selected objects parent name is " + clonedParent.getName());
            Trace.trace(TRACE_MASKT, "currently selected child is " + curSelection.getName());
            clonedParent.add((RoleItem)curSelection.clone());
            Trace.trace(TRACE_MASKT, "newitem after child count " + clonedParent.getChildCount());
            parentTree.add(clonedParent);
        }
        Trace.trace(TRACE_MASKT, "<- addChildToParent ");
        return parentTree;
    }

    public RoleItem findSubFolder(RoleItem curItem, RoleItem treeToSearch) {
        RoleItem childItem = null;
        RoleItem subItem = null;
        boolean found = false;
        Trace.trace(TRACE_MASKT, "-> findSubFolder ");
        Trace.trace(TRACE_MASKT, "looking for this item: " + curItem.getName().toString());
        Trace.trace(TRACE_MASKT, "tree to search children count " + treeToSearch.getChildCount());
        Trace.trace(TRACE_MASKT, "tree to search is " + treeToSearch.getName().toString());
        if (treeToSearch.getName().toString().equals(curItem.getName().toString())) {
            Trace.trace(TRACE_MASKT, "<- findSubFolder ");
            return treeToSearch;
        }
        int l = 0;
        while (l < treeToSearch.getChildCount() && !found) {
            childItem = (RoleItem)treeToSearch.getChildAt(l);
            Trace.trace(TRACE_MASKT, "childItem value " + childItem.getName());
            Trace.trace(TRACE_MASKT, "curItem looking for is " + curItem.getName().toString());
            if (childItem.getName().toString().equals(curItem.getName().toString())) {
                Trace.trace(TRACE_MASKT, "found item #1");
                found = true;
            } else {
                Trace.trace(TRACE_MASKT, "findsubfolder childitem kid count " + childItem.getChildCount());
                int s = 0;
                while (s < childItem.getChildCount() && !found) {
                    subItem = (RoleItem)childItem.getChildAt(s);
                    Trace.trace(TRACE_MASKT, "subItem value " + subItem.getName().toString());
                    Trace.trace(TRACE_MASKT, "curItem looking for is " + curItem.getName().toString());
                    RoleItem foundItem = this.findSubFolder(curItem, subItem);
                    if (foundItem != null) {
                        found = true;
                        childItem = foundItem;
                        Trace.trace(TRACE_MASKT, "found item #2");
                    }
                    ++s;
                }
            }
            ++l;
        }
        Trace.trace(TRACE_MASKT, "<- findSubFolder " + found);
        if (found) {
            return childItem;
        }
        return null;
    }

    public RoleItem findParentFolder(RoleItem curItem, RoleTree treeToSearch) {
        RoleItem roleItem = null;
        Object subItem = null;
        boolean found = false;
        Trace.trace(TRACE_MASKT, "-> findParentFolder ");
        Trace.trace(TRACE_MASKT, "curItem value " + curItem.getName().toString());
        Trace.trace(TRACE_MASKT, "treebranch to search " + treeToSearch.getName().toString());
        Trace.trace(TRACE_MASKT, "treebranch child size " + treeToSearch.getChildCount());
        int l = 0;
        while (l < treeToSearch.getChildCount()) {
            roleItem = (RoleItem)treeToSearch.getChildAt(l);
            if (roleItem.getName().toString().equals(curItem.getName().toString())) {
                l = treeToSearch.getChildCount();
                found = true;
            }
            ++l;
        }
        Trace.trace(TRACE_MASKT, "<- findParentFolder " + found);
        if (found) {
            return roleItem;
        }
        return null;
    }
}

